//vec3 poz;
vec4 poz;
/*!
 * <info>
 * <author>iq [ https://www.shadertoy.com/user/iq ]</author>
 * <name>Raymarching - Primitives</name>
 *
 * <description>
 *   A set of primitives and combination functions, for reference. More info here:
 *   [url=http://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm]http://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm[/url]
 * </description>
 *
 * <url>https://www.shadertoy.com/view/Xds3zN</url>
 *
 * <date>2013-03-26</date>
 *
 * <tags>procedural, 3d, raymarching, distancefields, primitives</tags>
 *
 * <synthclipse-importer-legal-note>
 *   As noted in: [ https://www.shadertoy.com/terms ]:
 *   If the author did not stated otherwise, this shader is licensed under
 *   Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
 *   [ http://creativecommons.org/licenses/by-nc-sa/3.0/deed.en_US ].
 * </synthclipse-importer-legal-note>
 * </info>
 */
/*
uniform vec3 iResolution;           // viewport resolution (in pixels)
uniform float iTime;                // shader playback time (in seconds)
uniform float iGlobalTime;          // shader playback time (in seconds) - <deprecated>
uniform float iTimeDelta;           // render time (in seconds)
uniform int iFrame;                 // shader playback frame
uniform float iChannelTime[4];      // channel playback time (in seconds)
uniform vec3 iChannelResolution[4]; // channel resolution (in pixels)
uniform vec4 iMouse;                // mouse pixel coords. xy: current (if MLB down), zw: click
uniform vec4 iDate;                 // (year, month, day, time in seconds)
uniform float iSampleRate;          // sound sample rate (i.e., 44100)
uniform float iFrameRate;           // frames per second (effectively "1.0 / iTimeDelta")
*/
vec3 iResolution= {1920,1080,0};          // viewport resolution (in pixels)
uniform float iTime;                // shader playback time (in seconds)
//uniform float iGlobalTime;          // shader playback time (in seconds) - <deprecated>
//uniform float iTimeDelta;           // render time (in seconds)
//uniform int iFrame;                 // shader playback frame
//uniform float iChannelTime[4];      // channel playback time (in seconds)
vec3 iChannelResolution[4]= {{512,512,0},{512,512,0},{512,512,0},{512,512,0}}; // channel resolution (in pixels)
vec4 iMouse= {1920/2,1080/2,0,0};               // mouse pixel coords. xy: current (if MLB down), zw: click
//uniform vec4 iDate;                 // (year, month, day, time in seconds)
//uniform float iSampleRate;          // sound sample rate (i.e., 44100)
//uniform float iFrameRate;           // frames per second (effectively "1.0 / iTimeDelta")

//uniform mat3 mat3cam;
uniform mat4 mat4cam;
uniform mat4 Rotation;
uniform mat4 Rotation2;

uniform mat4 elRotation1;
uniform mat4 elRotation2;
uniform mat4 elRotation3;

// timers for sinus movement
uniform vec3 t1;
uniform vec3 t2;
uniform vec3 t3;

uniform vec3 rayorigin;
uniform vec3 raydirection;
uniform vec3 upvector;

uniform float fov;
uniform float depthmult;
uniform float depthmax;
uniform float scale;

varying vec2 texCoord;

float depth;
float depthbig;
mat3 ca;

uniform int showdepthmap;

uniform sampler2D colorMap;
uniform sampler2D depthMap;
uniform samplerCube envMap;

// The MIT License
// Copyright  2013 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


// A list of useful distance function to simple primitives, and an example on how to
// do some interesting boolean operations, repetition and displacement.
//
// More info here: http://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm


//#define AA 1   // make this 1 is your machine is too slow

//------------------------------------------------------------------

float sdPlane( vec3 p )
{
    return p.y;
}

float sdSphere( vec3 p, float s )
{
    return length(p)-s;
}

float sdBox( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdEllipsoid( in vec3 p, in vec3 r )
{
    return (length( p/r ) - 1.0) * min(min(r.x,r.y),r.z);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
    return length(max(abs(p)-b,0))-r;
}

// ellipsoid distance function by xwize (shadertoy)
float Ellipsoid2( vec3 p, vec3 r )
{
    //return (length( p/r ) - 1.0) * min(min(r.x,r.y),r.z);
    /*
    highp vec3 els = vec3(k,2.0-k,k);
    highp vec3 elsn = normalize(els);
    sphere.d = length((p - centre)*elsn) - r/length(els);
    */
    return length((p)*normalize(r)) - r/length(r);

    //return length(max(abs(p)-b,0))-r;
      //return length(max(abs(p)-b,0))-length(r);
}

float sdTorus( vec3 p, vec2 t )
{
    return length( vec2(length(p.xz)-t.x,p.y) )-t.y;
}

float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
#if 0
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
#else
    float d1 = q.z-h.y;
    float d2 = max((q.x*0.866025+q.y*0.5),q.y)-h.x;
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
#endif
}

float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p-a, ba = b-a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}

float sdEquilateralTriangle(  in vec2 p )
{
    const float k = sqrt(3.0);
    p.x = abs(p.x) - 1.0;
    p.y = p.y + 1.0/k;
    if( p.x + k*p.y > 0.0 ) p = vec2( p.x - k*p.y, -k*p.x - p.y )/2.0;
    p.x += 2.0 - 2.0*clamp( (p.x+2.0)/2.0, 0.0, 1.0 );
    return -length(p)*sign(p.y);
}

float sdTriPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    float d1 = q.z-h.y;
#if 1
    // distance bound
    float d2 = max(q.x*0.866025+p.y*0.5,-p.y)-h.x*0.5;
#else
    // correct distance
    h.x *= 0.866025;
    float d2 = sdEquilateralTriangle(p.xy/h.x)*h.x;
#endif
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdCylinder( vec3 p, vec2 h )
{
    vec2 d = abs(vec2(length(p.xz),p.y)) - h;
    return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdCone( in vec3 p, in vec3 c )
{
    vec2 q = vec2( length(p.xz), p.y );
    float d1 = -q.y-c.z;
    float d2 = max( dot(q,c.xy), q.y);
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdConeSection( in vec3 p, in float h, in float r1, in float r2 )
{
    float d1 = -p.y - h;
    float q = p.y - h;
    float si = 0.5*(r1-r2)/h;
    float d2 = max( sqrt( dot(p.xz,p.xz)*(1.0-si*si)) + q*si - r2, q );
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdPryamid4(vec3 p, vec3 h ) // h = { cos a, sin a, height }
{
    // Tetrahedron = Octahedron - Cube
    float box = sdBox( p - vec3(0,-2.0*h.z,0), vec3(2.0*h.z) );

    float d = 0.0;
    d = max( d, abs( dot(p, vec3( -h.x, h.y, 0 )) ));
    d = max( d, abs( dot(p, vec3(  h.x, h.y, 0 )) ));
    d = max( d, abs( dot(p, vec3(  0, h.y, h.x )) ));
    d = max( d, abs( dot(p, vec3(  0, h.y,-h.x )) ));
    float octa = d - h.z;
    return max(-box,octa); // Subtraction
}

float length2( vec2 p )
{
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p )
{
    p = p*p*p;
    p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p )
{
    p = p*p;
    p = p*p;
    p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}

float sdTorus82( vec3 p, vec2 t )
{
    vec2 q = vec2(length2(p.xz)-t.x,p.y);
    return length8(q)-t.y;
}

float sdTorus88( vec3 p, vec2 t )
{
    vec2 q = vec2(length8(p.xz)-t.x,p.y);
    return length8(q)-t.y;
}

float sdCylinder6( vec3 p, vec2 h )
{
    return max( length6(p.xz)-h.x, abs(p.y)-h.y );
}

//------------------------------------------------------------------

float opS( float d1, float d2 )
{
    return max(-d2,d1);
}

vec2 opU( vec2 d1, vec2 d2 )
{
    return (d1.x<d2.x) ? d1 : d2;
}

vec3 opRep( vec3 p, vec3 c )
{
    return mod(p,c)-0.5*c;
}

vec3 opTwist( vec3 p )
{
    float  c = cos(10.0*p.y+10.0);
    float  s = sin(10.0*p.y+10.0);
    mat2   m = mat2(c,-s,s,c);
    return vec3(m*p.xz,p.y);
}

//------------------------------------------------------------------

float blob2(float d1, float d2)
{
    float k = 4.5;
    return -log(exp(-k*d1)+exp(-k*d2))/k;
}
float blob3(float d1, float d2,float d3)
{
    float k = 4.5;
    return -log(exp(-k*d1)+exp(-k*d2)+exp(-k*d3))/k;
}

vec2 map( in vec3 pos )
{
//    pos+=vec3(-10.0,0.0,4.0);

    vec4 p2=vec4(pos,1.0f);
    //p2.y -= 6.5;
    //p2.x -= 3.0;
    p2 = Rotation * p2;
    vec3 p3=vec3(p2.xyz);

    vec4 pb2=vec4(pos,1.0f);
    //p2.y -= 6.5;
    //p2.x -= 3.0;
    pb2 = Rotation2 * pb2;
    vec3 pb3=vec3(pb2.xyz);

    //vec2 res=vec2( sdPlane(     pos), 1.0 );//vec2(1.0f, 1.0f);
    vec2 res=vec2(15.0f, -100.0f);
    //vec2 res=vec2(0.0f, -100.0f);
    /*
        res = opU( vec2( sdPlane(     pos), 1.0 ),
    	                vec2( sdSphere(    pos-vec3( 0.0,0.25, 0.0), 0.25 ), 46.9 ) );
    */
    //res = opU( res, vec2( sdBox(       p3-vec3( 1.0,0.25, 0.0), vec3(0.25) ), 3.0 ) );
    //res = opU( res, vec2( udRoundBox(  p3-vec3( 1.0,0.25, 1.0), vec3(0.15), 0.1 ), 41.0 ) );


    //vec2 r1 = opU( res, vec2( 2.5f*sdSphere(  pos+vec3(0.0,0.0,0.0), 1.0f), 3.0 ) );
//vec2 r1 = opU( res, vec2( sdBox(      pb3+vec3(0.0,0.0,0.0),  vec3(1.5f) ), 3.0 ) );
//vec2 r1 = opU( res, vec2( 3.0*sdSphere(    pos+vec3(0.0,1.0,0.0), 3.0 ) , 3.0 ) );
//vec2 r2 = opU( res, vec2( sdBox(       p3+vec3(0.0,0.0,0.0),  vec3(2.0f) ), 3.0 ) );
    //vec2 r2 = opU( res, vec2( udRoundBox(  pb3+vec3(0.0,0.0,0.0), vec3(2.0f), 0.1 ), 41.0 ) );
    //res = opU( res, vec2( 2.5f*sdSphere(  pos+vec3(0.0,0.0,0.0), 1.0f), 41.0 ) );



pos+=vec3(-10.0,0.0,4.0);
const float r=1.25f;
const float d2r=6.28f/360.0f;
vec3 m1=vec3(r*sin(t1.x*d2r),r*sin(t1.y*d2r),r*sin(t1.z*d2r));
vec3 m2=vec3(r*sin(t2.x*d2r),r*sin(t2.y*d2r),r*sin(t2.z*d2r));
vec3 m3=vec3(r*sin(t3.x*d2r),r*sin(t3.y*d2r),r*sin(t3.z*d2r));

const float elsize=3.0f;
vec4 rot1=vec4(vec3(pos+vec3(0.0,0.0,0.0)+m1).xyz,1.0f)*Rotation;
vec3 rot1_=vec3(rot1.xyz);
vec2 r1 = opU(res, vec2(Ellipsoid2(rot1_, vec3(0.1*elsize, 0.2*elsize, 0.2*elsize)), 3.0) );

rot1=vec4(vec3(pos+vec3(0.0,0.0,0.0)+m2).xyz,1.0f)*Rotation2;
rot1_=vec3(rot1.xyz);
vec2 r2 = opU(res, vec2(Ellipsoid2(rot1_, vec3(0.1*elsize, 0.2*elsize, 0.2*elsize)), 3.0) );

vec2 r3 = opU(res, vec2(sdEllipsoid(pos+vec3(0.0,0.0,0.0)+m3, vec3(0.15*elsize, 0.2*elsize, 0.05*elsize)), 3.0) );
//vec2 r1 = opU(res, vec2(sdSphereSq(pos+vec3(0.0,0.0,0.0)+m1, 1.0), 3.0 ));
//vec2 r2 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m2, 1.0), 3.0 ));
//vec2 r3 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m3, 1.0), 3.0 ));

res=vec2(blob3(r1.x,r2.x,r3.x),r1.y);
pos-=vec3(-10.0,0.0,4.0);

//--------------test blobs ------------------
/*
pos+=vec3(10.0,0.0,4.0);
r1 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m1, 1.0), 3.0 ));
r2 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m2, 1.0), 3.0 ));
r3 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m3, 1.0), 3.0 ));
res=vec2(blob3(r1.x,r2.x,r3.x),r1.y);
pos-=vec3(10.0,0.0,4.0);

pos+=vec3(10.0,0.0,-4.0);
r1 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m1, 1.0), 3.0 ));
r2 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m2, 1.0), 3.0 ));
r3 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m3, 1.0), 3.0 ));
res=vec2(blob3(r1.x,r2.x,r3.x),r1.y);
pos-=vec3(10.0,0.0,-4.0);

pos+=vec3(-10.0,0.0,-4.0);
r1 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m1, 1.0), 3.0 ));
r2 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m2, 1.0), 3.0 ));
r3 = opU(res, vec2(sdSphere(pos+vec3(0.0,0.0,0.0)+m3, 1.0), 3.0 ));
res=vec2(blob3(r1.x,r2.x,r3.x),r1.y);
pos-=vec3(-10.0,0.0,-4.0);
*/
//--------------test blobs ------------------

//const float r=1.25f;
//const float d2r=6.28f/360.0f;
//vec3 m1=vec3(r*sin(t1.x*d2r),r*sin(t1.y*d2r),r*sin(t1.z*d2r));
//res = opU( res, vec2( sdHexPrism(  pos, vec2(0.25,0.05) ),17.0 ) );
res = opU( res, vec2( sdBox(  pos+vec3(0.0,0.0,0.0)*vec3(scale), vec3(0.5*scale) ),17.0 ) );
res = opU( res, vec2( sdBox(  pos+vec3(-2.0,0.0,0.0)*vec3(scale), vec3(0.5*scale) ),17.0 ) );
res = opU( res, vec2( sdBox(  pos+vec3(2.0,0.0,0.0)*vec3(scale), vec3(0.5*scale) ),17.0 ) );



//    res = vec2(sdBox(vec3(-10.0,0.0,4.0),vec3(0.5)),3.0f);
//  res = opU( res, vec2( sdTorus(     pos-vec3( 0.0,0.25, 1.0), vec2(0.20,0.05) ), 3.0 ) );

    //res = opU(res,vec2(sdBox(p3-vec3(1.0,0.25,0.0),vec3(1.0)),3.0));

    //res = opU( res, vec2( sdBox( pos+vec3(0.0,2.0,0.0),  vec3(2.0f) ), 3.0 ) );

    /*
    	res = opU( res, vec2( sdTorus(     pos-vec3( 0.0,0.25, 1.0), vec2(0.20,0.05) ), 25.0 ) );
        res = opU( res, vec2( sdCapsule(   pos,vec3(-1.3,0.10,-0.1), vec3(-0.8,0.50,0.2), 0.1  ), 31.9 ) );
    	res = opU( res, vec2( sdTriPrism(  pos-vec3(-1.0,0.25,-1.0), vec2(0.25,0.05) ),43.5 ) );
    	res = opU( res, vec2( sdCylinder(  pos-vec3( 1.0,0.30,-1.0), vec2(0.1,0.2) ), 8.0 ) );
    	res = opU( res, vec2( sdCone(      pos-vec3( 0.0,0.50,-1.0), vec3(0.8,0.6,0.3) ), 55.0 ) );
    	res = opU( res, vec2( sdTorus82(   pos-vec3( 0.0,0.25, 2.0), vec2(0.20,0.05) ),50.0 ) );
    	res = opU( res, vec2( sdTorus88(   pos-vec3(-1.0,0.25, 2.0), vec2(0.20,0.05) ),43.0 ) );
    	res = opU( res, vec2( sdCylinder6( pos-vec3( 1.0,0.30, 2.0), vec2(0.1,0.2) ), 12.0 ) );
    	res = opU( res, vec2( sdHexPrism(  pos-vec3(-1.0,0.20, 1.0), vec2(0.25,0.05) ),17.0 ) );
    	res = opU( res, vec2( sdPryamid4(  pos-vec3(-1.0,0.15,-2.0), vec3(0.8,0.6,0.25) ),37.0 ) );
        res = opU( res, vec2( opS( udRoundBox(  pos-vec3(-2.0,0.2, 1.0), vec3(0.15),0.05),
    	                           sdSphere(    pos-vec3(-2.0,0.2, 1.0), 0.25)), 13.0 ) );
        res = opU( res, vec2( opS( sdTorus82(  pos-vec3(-2.0,0.2, 0.0), vec2(0.20,0.1)),
    	                           sdCylinder(  opRep( vec3(atan(pos.x+2.0,pos.z)/6.2831, pos.y, 0.02+0.5*length(pos-vec3(-2.0,0.2, 0.0))), vec3(0.05,1.0,0.05)), vec2(0.02,0.6))), 51.0 ) );
    	res = opU( res, vec2( 0.5*sdSphere(    pos-vec3(-2.0,0.25,-1.0), 0.2 ) + 0.03*sin(50.0*pos.x)*sin(50.0*pos.y)*sin(50.0*pos.z), 65.0 ) );
    	res = opU( res, vec2( 0.5*sdTorus( opTwist(pos-vec3(-2.0,0.25, 2.0)),vec2(0.20,0.05)), 46.7 ) );
        res = opU( res, vec2( sdConeSection( pos-vec3( 0.0,0.35,-2.0), 0.15, 0.2, 0.1 ), 13.67 ) );
        res = opU( res, vec2( sdEllipsoid( pos-vec3( 1.0,0.35,-2.0), vec3(0.15, 0.2, 0.05) ), 43.17 ) );
    */
    /*
    poz=pos;

//poz.z=poz.z*depthmult;
    vec4 poz4=vec4(poz.xyz,1.0f);
    poz4*=mat4cam;
    poz=poz4.xyz;
poz.z=poz.z*depthmult;
//poz.z=depthmax-poz.z;
*/
    return res;
}

vec2 castRay( in vec3 ro, in vec3 rd )
{
    float tmin = 1.0;
    float tmax = 20.0;
    //float tmin = -100.0;
    //float tmax = 200.0;

//#if 1
    // bounding volume
    //float tp1 = (0.0-ro.y)/rd.y; if( tp1>0.0 ) tmax = min( tmax, tp1 );
    //float tp2 = (1.6-ro.y)/rd.y; if( tp2>0.0 ) { if( ro.y>1.6 ) tmin = max( tmin, tp2 );                                                 else           tmax = min( tmax, tp2 ); }
    float tp1 = (0.0-ro.y)/rd.y; //if( tp1>15.0 ) tmax = min( tmax, tp1 );
    float tp2 = (1.6-ro.y)/rd.y; //if( tp2>15.0 ) { if( ro.y>1.6 ) tmin = max( tmin, tp2 );                                                 else           tmax = min( tmax, tp2 ); }
//#endif

    float t = tmin;
    float m = -10.0;
    for( int i=0; i<64; i++ )
    {
        float precis = 0.0005*t;//0.0005*t;//*t;
        vec2 res = map( ro+rd*t );
        if( res.x<precis ) break;//|| t>tmax ) break;
        t += res.x;
        m = res.y;
    }

    //if( t>tmax ) m=-1.0;
    return vec2( t, m );
}

float softshadow( in vec3 ro, in vec3 rd, in float mint, in float tmax )
{
    float res = 1.0;
    float t = mint;
    for( int i=0; i<16; i++ )
    {
        float h = map( ro + rd*t ).x;
        res = min( res, 8.0*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001) break;// || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

vec3 calcNormal( in vec3 pos )
{
    vec2 e = vec2(1.0,-1.0)*0.5773*0.0005;
    return normalize( e.xyy*map( pos + e.xyy ).x +
                      e.yyx*map( pos + e.yyx ).x +
                      e.yxy*map( pos + e.yxy ).x +
                      e.xxx*map( pos + e.xxx ).x );
    /*
    vec3 eps = vec3( 0.0005, 0.0, 0.0 );
    vec3 nor = vec3(
        map(pos+eps.xyy).x - map(pos-eps.xyy).x,
        map(pos+eps.yxy).x - map(pos-eps.yxy).x,
        map(pos+eps.yyx).x - map(pos-eps.yyx).x );
    return normalize(nor);
    */
}

float calcAO( in vec3 pos, in vec3 nor )
{
    float occ = 0.0;
    float sca = 1.0;
    for( int i=0; i<5; i++ )
    {
        float hr = 0.01 + 0.12*float(i)/4.0;
        vec3 aopos =  nor * hr + pos;
        float dd = map( aopos ).x;
        occ += -(dd-hr)*sca;
        sca *= 0.95;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 );
}

vec3 render( in vec3 ro, in vec3 rd )
{
vec3 pos;
    vec3 col = vec3(0.7, 0.7, 1.0) +rd.y*0.8;
    vec2 res = castRay(ro,rd);
    float t = res.x;
    float m = res.y;
    //if( m>-0.5 )
    {

        pos = ro + t*rd;
        vec3 nor = calcNormal( pos );
        vec3 ref = reflect( rd, nor );

//vec3 camdir = normalize( ca * vec3(0.0,0.0,1.0) ); // 2.0 is the lens length
//vec3 envcol = texture(envMap, reflect( rd, nor )).rgb;
vec3 envcol = texture(envMap, vec3(ref.x,-ref.y,-ref.z)).rgb;
        // material
        col = 0.45 + 0.35*sin( vec3(0.05,0.08,0.10)*(m-1.0) );
/*
        if( m<-10.0)
        {
            float f = mod( floor(1.0*pos.z) + floor(1.0*pos.x), 2.0);
            col = 0.3 + 0.1*f*vec3(1.0);
            col = vec3(col.rg,1.0f);
        }
*/
        // lighitng
        float occ = calcAO( pos, nor );
        vec3  lig = normalize( vec3(-0.4, 0.7, -0.6) );
        float amb = clamp( 0.5+0.5*nor.y, 0.0, 1.0 );
        float dif = clamp( dot( nor, lig ), 0.0, 1.0 );
        float bac = clamp( dot( nor, normalize(vec3(-lig.x,0.0,-lig.z))), 0.0, 1.0 )*clamp( 1.0-pos.y,0.0,1.0);
        float dom = smoothstep( -0.1, 0.1, ref.y );
        float fre = pow( clamp(1.0+dot(nor,rd),0.0,1.0), 2.0 );
        float spe = pow(clamp( dot( ref, lig ), 0.0, 1.0 ),16.0);

        //dif *= softshadow( pos, lig, 0.02, 2.5 );
        //dom *= softshadow( pos, ref, 0.02, 2.5 );

        vec3 lin = vec3(0.0);
        lin += 1.30*dif*vec3(1.00,0.80,0.55);
        lin += 2.00*spe*vec3(1.00,0.90,0.70)*dif;
        lin += 0.40*amb*vec3(0.60,0.40,1.00)*occ;
        lin += 0.50*dom*vec3(0.60,0.40,1.00)*occ;
        lin += 0.50*bac*vec3(0.25,0.25,0.25)*occ;
        lin += 0.25*fre*vec3(1.00,1.00,1.00)*occ;
        col = col*lin;

col = col+envcol;
        //col = mix( col, vec3(0.8,0.9,1.0), 1.0-exp( -0.0002*t*t*t ) );
    }
/*
//depthmult value interpolation:
const float neardepth = 22*256;//11854;//3813.0f;//976128.0f;
const float fardepth   = 70*256;//1203;//887.0f;//227072.0f;
const float neardepthmult  = 107000;//8300;//300.0f;
const float fardepthmult = 1190000;//757760;//5470.0f;
//depthbig
float depthbig2=t;
float calcdepthmult = fardepthmult-((depthbig2-fardepth)/(neardepth-fardepth))*(fardepthmult-neardepthmult);
float tmp=calcdepthmult;
//calcdepthmult=107000;
    float a=1000.0f-t*depthmult;
    //depth/=depthmult;

    //if (a<depth)//||m<-1.5)//200000.0f
    //if(depthmax-poz.z*depthmult<=depth) //investigate further
*/

//poz.z=-poz.z;
//poz*=mat4cam;
//poz.z/=200.0f;
//poz.z=1.0f-poz.z;
//poz.z*=depthmult;

//iq's method
poz=vec4(pos.xyz,1.0f);// /10.0f
poz=mat4cam*poz;
float zp = poz.z;
float wp = poz.w;
float x2 = zp/wp;
x2=zp/wp*depthmult-depthmax;
//x2=pos.z/10.0f;


//alternative iq's method
/*
float far = 20.0f;
float near = 0.01f;
float a = (far+near)/(far-near);
float b = 2.0*far*near/(far-near);
x2 = a + b/pos.z;
*/

//    float x2=poz.z/10.0f;
    //if(poz.z>depth) //investigate further
    if(x2>depth) //investigate further
    {
        col=texture2D(colorMap, texCoord);

/*
        float r1=texture2D(depthMap, texCoord).r;
        float g1=texture2D(depthMap, texCoord).g;
        //col=vec3(r1,g1,depth);
        col=vec3(r1,g1,calcdepthmult/11954);
*/

/*
    float d=calcdepthmult;
    double x2=d;//*256*256;
    double r2=floor(x2/double(256.0)); x2=x2-r2*double(256.0);
    double g2=x2;
    float r1=float(r2/256.0f);
    float g1=float(g2/256.0f);
        col=vec3(r1,g1,depth);
*/
        //col=vec3(0,0,depth);


    }



    else
    {
    }

    if (showdepthmap==1){

    float x2=depth;
    //tmp=256*65536-1; //resulting in 255,255,254
//x2=tmp;
/*
    float r2=floor(x2/float(65536.0)); x2=x2-r2*float(65536.0);
    float g2=floor(x2/float(256.0)); x2=x2-g2*float(256.0);
    float b2=x2;
    float r1=float(r2/255.0f);
    float g1=float(g2/255.0f);
    float b1=float(b2/255.0f);

    col = vec4(r1,g1,b1,1.0f);
*/
//col = vec4(x2,x2,x2,1.0f);
col = texture2D(depthMap, texCoord);
    }
        if (showdepthmap==2){
    //tmp=256*65536-1; //resulting in 255,255,254
//x2=tmp;
/*
    float r2=floor(x2/float(65536.0)); x2=x2-r2*float(65536.0);
    float g2=floor(x2/float(256.0)); x2=x2-g2*float(256.0);
    float b2=x2;
    float r1=float(r2/255.0f);
    float g1=float(g2/255.0f);
    float b1=float(b2/255.0f);
*/
//col = vec4(r1,g1,b1,1.0f);
col = vec4(x2,x2,x2,1.0f);
if (x2>1.0f)
    col=vec4(0.0f,1.0f,1.0f,1.0f);
if (x2<0.0f)
    col=vec4(0.0f,0.0f,1.0f,1.0f);
    }


    //for (int i=0;i<4;i++) for (int j=0;j<4;j++){mat4cam[i][j]=i/5.0f+j/5.0f;}
//displaying projection matrix for debugging purposes:
/*
    int x=texCoord.x*6.0;
    int y=texCoord.y*6.0;
    if (x<4&&y<4)
        col=vec4(mat4cam[x][y],mat4cam[x][y],mat4cam[x][y],1.0f);
    else
        col=vec4(1.0f,0.0f,0.0f,1.0f);
*/
    return vec3(clamp(col,0.0,1.0));
}

mat3 setCamera( in vec3 ro, in vec3 ta, float cr )
{
//return mat3cam;
    vec3 cw = normalize(ta-ro);

    //vec3 cp = vec3(sin(cr), cos(cr),0.0);
    vec3 cp = upvector;

    vec3 cu = normalize( cross(cw,cp) );
    vec3 cv = normalize( cross(cu,cw) );
    return mat3( cu, cv, cw );
}

void mainImage( inout vec4 fragColor, in vec2 fragCoord )
{
    float r1=texture2D(depthMap, texCoord).r;
    float g1=texture2D(depthMap, texCoord).g;
    float b1=texture2D(depthMap, texCoord).b;

//depth=r1;
    depth=(r1*256.0f*256.0f+g1*256.0f+b1)/65536.0f;

    vec2 mo = iMouse.xy/iResolution.xy;
    float time = 15.0 + iTime;


    vec3 tot = vec3(0.0);
#if AA>1
    for( int m=0; m<AA; m++ )
        for( int n=0; n<AA; n++ )
        {
            // pixel coordinates
            vec2 o = vec2(float(m),float(n)) / float(AA) - 0.5;
            vec2 p = (-iResolution.xy + 2.0*(fragCoord+o))/iResolution.y;
#else
    vec2 p = (-iResolution.xy + 2.0*fragCoord)/iResolution.y;
#endif

            // camera
            vec3 ro = vec3( -0.5+3.5*cos(0.1*time + 6.0*mo.x), 3.0 + 2.0*mo.y, 0.5 + 4.0*sin(0.1*time + 6.0*mo.x) );
            vec3 ta = vec3( -0.5, -0.4, 0.5 );

//dm installed camera control:
            ro=rayorigin;// /vec3(20.0f);
            ta=raydirection;// /vec3(20.0f);

            // camera-to-world transformation
            ca = setCamera( ro, ta, 0.0f );
            //mat3 ca = mat3cam;

            // ray direction
            //vec3 rd = ca * normalize( vec3(p.x,p.y+1.0,2.0) );
    //vec3 rd = ca * normalize( vec3(p.x,p.y,2.0) );
      vec3 rd = ca * normalize( vec3(p.x,p.y,fov ) );
            //vec4 rd1= ca * vec4(normalize( vec3(p.xy,2.0) ),1.0f);
            //vec3 rd = vec3(rd1.xyz);

            // render
            vec3 col = render( ro, rd );

            // gamma
            //col = pow( col, vec3(0.4545) );

            tot += col;
#if AA>1
        }
    tot /= float(AA*AA);
#endif


    fragColor = vec4( tot, 1.0 );
}

void main()
{
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
    mainImage(color, gl_FragCoord.xy);

    gl_FragColor = color;
}
